// Infopage.cpp : implementation file
//

#include "stdafx.h"
#include "Ultima_C++Demo.h"
#include "MainSheet.h"
#include "UtilsPage.h"
#include <winspool.h>

//#############################################################################

// CInfoPage dialog
IMPLEMENT_DYNAMIC(CUtilsPage, CPropertyPage)

CUtilsPage::CUtilsPage() : CPropertyPage(CUtilsPage::IDD)
{
}

CUtilsPage::~CUtilsPage()
{
}

void CUtilsPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_UTILSMSG, UtilsMessage);
}

BEGIN_MESSAGE_MAP(CUtilsPage, CPropertyPage)
	ON_BN_CLICKED(IDC_BTN_UTILSMSG_CLR, &CUtilsPage::OnBnClickedBtnUtilsmsgClr)
	ON_BN_CLICKED(IDC_BTN_ENABLELOGGING, &CUtilsPage::OnBnClickedBtnEnableLogging)
	ON_BN_CLICKED(IDC_BTN_DISABLELOGGING, &CUtilsPage::OnBnClickedBtnDisableLogging)
END_MESSAGE_MAP()

//#############################################################################

// CInfoPage message handlers
BOOL CUtilsPage::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	Parent = (CMainSheet *)GetParent();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

//****************************************************************************

void CUtilsPage::OnBnClickedBtnUtilsmsgClr()
{
	UtilsMessage.SetWindowText(_T(""));
}

//****************************************************************************

void CUtilsPage::AddUtilsMessage(CString pMessage)
{
	Parent->AddString(&UtilsMessage, pMessage);
}

//****************************************************************************

void CUtilsPage::OnBnClickedBtnEnableLogging()
{
	PFNIDCONTROL pFnControl = (PFNIDCONTROL)GetProcAddress(Parent->hLib, "ID_Control");
	if (!pFnControl)
	{
		FUNCTION_NOT_ACCESSED(MoveCard);
	}

	else
	{
		ID_CONTROL control;
		ID_RETURN SDKReturn = (*pFnControl)(Parent->hSession, ID_READ, &control);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(EnableLoggingRead, SDKReturn);
		}

		if ((control & ID_LOGGING) == 0)
		{
			control = (ID_CONTROL)(control + ID_LOGGING);
			SDKReturn = (*pFnControl)(Parent->hSession, ID_WRITE, &control);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(EnableLoggingWrite, SDKReturn);
			}
			else
			{
				AddUtilsMessage(_T("SDK Logging: ENABLED"));
				AddUtilsMessage(_T(""));
			}
		}
	}
}

//****************************************************************************

void CUtilsPage::OnBnClickedBtnDisableLogging()
{
	PFNIDCONTROL pFnControl = (PFNIDCONTROL)GetProcAddress(Parent->hLib, "ID_Control");
	if (!pFnControl)
	{
		FUNCTION_NOT_ACCESSED(MoveCard);
	}

	else
	{
		ID_CONTROL control;
		ID_RETURN SDKReturn = (*pFnControl)(Parent->hSession, ID_READ, &control);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(DisableLoggingRead, SDKReturn);
		}

		if ((control & ID_LOGGING) != 0)
		{
			control = (ID_CONTROL)(control & ~ID_LOGGING);
			SDKReturn = (*pFnControl)(Parent->hSession, ID_WRITE, &control);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(DisableLoggingWrite, SDKReturn);
			}
			else
			{
				AddUtilsMessage(_T("SDK Logging: DISABLED"));
				AddUtilsMessage(_T(""));
			}
		}
	}
}
